/*

Macro_Scripts File
Created:  November 07 2007
Author:   PF Breton

Action items related to mental ray


*/


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK


--------------------------------------------------------------------------------------------------
-- Indirect Illumination Tab from Render Dialog

MacroScript IndirectIlluminationTab_mentalray
ButtonText:~INDIRECTILLUMINATIONTAB_MENTALRAY_BUTTONTEXT~
category:"mental ray" 
internalCategory:"mental ray" 
Tooltip:~INDIRECTILLUMINATIONTAB_MENTALRAY_TOOLTIP~ 

(
	on execute do
	(
		actionMan.executeAction 0 "60010"  -- Render: Render SetUp... dialog 
		if tabbedDialogs.isOpen #render then tabbedDialogs.setCurrentPage #render #(1163987115, 1981678594) --launches the Indirect Illumination Tab
	)	
	
	on isenabled return ((classof renderers.current == mental_ray_renderer))
	on isvisible return ((classof renderers.current == mental_ray_renderer))
)



--------------------------------------------------------------------------------------------------
-- Mental Ray Geometry Caching

MacroScript ClearGeometryCache_mentalray
            ButtonText:~CLEARGEOMETRYCACHE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalcategory:"mental ray"
            Tooltip:~CLEARGEOMETRYCACHE_MENTALRAY_TOOLTIP~
(
	on IsEnabled Do if ((classof renderers.current)==mental_ray_renderer) then not renderers.current.isGeometryCacheEmpty else false
	On IsVisible Do if ((classof renderers.current)==mental_ray_renderer) then not renderers.current.isGeometryCacheEmpty else false
	On Execute Do Try (if ((classof renderers.current)==mental_ray_renderer) do renderers.current.ClearGeometryCache()) Catch ()
)


--------------------------------------------------------------------------------------------------
-- FINAL GATHER Mental Ray Object Properties Toggles
--------------------------------------------------------------------------------------------------
MacroScript FG_Return_ObjColor_mentalray
            ButtonText:~FG_RETURN_OBJCOLOR_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~FG_RETURN_OBJCOLOR_MENTALRAY_TOOLTIP~
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_castModeFGIllum == #ObjColor) Catch () 
	On Execute Do Try ($.mr_castModeFGIllum = #ObjColor)	Catch ()
)


MacroScript FG_Return_Black_mentalray
            ButtonText:~FG_RETURN_BLACK_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~FG_RETURN_BLACK_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_castModeFGIllum == #Black) Catch () 
	On Execute Do Try ($.mr_castModeFGIllum = #Black)	Catch ()
)


MacroScript FG_Invisible_mentalray
            ButtonText:~FG_INVISIBLE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~FG_INVISIBLE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_castModeFGIllum == #Invisible) Catch () 
	On Execute Do Try ($.mr_castModeFGIllum = #Invisible)	Catch ()
)


MacroScript FG_Receive_mentalray
            ButtonText:~FG_RECEIVE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~FG_RECEIVE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_rcvFGIllum ) Catch ()
	On Execute Do Try ($.mr_rcvFGIllum  = not $.mr_rcvFGIllum )	Catch ()
)



--------------------------------------------------------------------------------------------------
-- CAUSTICS Mental Ray Object Properties Toggles
--------------------------------------------------------------------------------------------------
MacroScript Caustics_Exclude_mentalray
            ButtonText:~CAUSTICS_EXCLUDE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~CAUSTICS_EXCLUDE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_excludeCaustics) Catch ()
	On Execute Do Try ($.mr_excludeCaustics = not $.mr_excludeCaustics)	Catch ()
)

MacroScript Caustics_Receive_mentalray
            ButtonText:~CAUSTICS_RECEIVE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~CAUSTICS_RECEIVE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return ((selection.count == 1) and  not $.mr_excludeCaustics)
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.rcvcaustics) Catch ()
	On Execute Do Try ($.rcvcaustics = not $.rcvcaustics)	Catch ()
)

MacroScript Caustics_Generate_mentalray
            ButtonText:~CAUSTICS_GENERATE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~CAUSTICS_GENERATE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return ((selection.count == 1) and  not $.mr_excludeCaustics)
	On IsVisible Return ((superclassof $ == GeometryClass) or (superclassof $ == Light))
	on ischecked Do	Try ($.generatecaustics) Catch ()
	On Execute Do Try ($.generatecaustics = not $.generatecaustics)	Catch ()
)

--------------------------------------------------------------------------------------------------
--GLOBAl ILLUMINATION Mental Ray Object Properties Toggles
--------------------------------------------------------------------------------------------------
MacroScript GlobalIllum_Exclude_mentalray
            ButtonText:~GLOBALILLUM_EXCLUDE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~GLOBALILLUM_EXCLUDE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return (selection.count == 1) 
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.mr_excludeGlobalIllum ) Catch ()
	On Execute Do Try ($.mr_excludeGlobalIllum = not $.mr_excludeGlobalIllum )	Catch ()
)


MacroScript GlobalIllum_Receive_mentalray
            ButtonText:~GLOBALILLUM_RECEIVE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~GLOBALILLUM_RECEIVE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return ((selection.count == 1) and  not $.mr_excludeGlobalIllum)
	On IsVisible Return ((superclassof $ == GeometryClass))
	on ischecked Do	Try ($.rcvGlobalIllum) Catch ()
	On Execute Do Try ($.rcvGlobalIllum = not $.rcvGlobalIllum)	Catch ()
)


MacroScript GlobalIllum_Generate_mentalray
            ButtonText:~GLOBALILLUM_GENERATE_MENTALRAY_BUTTONTEXT~
            category:"mental ray"
            internalCategory:"mental ray"
            Tooltip:~GLOBALILLUM_GENERATE_MENTALRAY_TOOLTIP~ 
(

	on IsEnabled Return ((selection.count == 1) and  not $.mr_excludeGlobalIllum)
	On IsVisible Return ((superclassof $ == GeometryClass) or (superclassof $ == Light))
	on ischecked Do	Try ($.generateGlobalIllum) Catch ()
	On Execute Do Try ($.generateGlobalIllum = not $.generateGlobalIllum)	Catch ()
)





--------------------------------------------------------------------------------------------------
/*


Macro Script that converts selected Lights into mental ray area lights

Revision History:


	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		migrated bug fixes from the "utility-mentalry_ConvertAreaLights.ms"



*/

macroScript ConvertToAreaLight
category:"mental ray"  
internalCategory:"mental ray"  
tooltip:~CONVERTTOAREALIGHT_TOOLTIP~ 
buttontext:~CONVERTTOAREALIGHT_BUTTONTEXT~ 
(

	include "stdplugs\stdscripts\Light-mentalray_AreaOmni.ms" --LOC_Notes: do not localize this
	include "stdplugs\stdscripts\Light-mentalray_AreaSpot.ms" --LOC_Notes: do not localize this

	local Alight, Sel_props, Sel_Objs, tg, Sel_converted
----------------------------------------------------------------------------------------
-- Added Jan 30 2001 2 Functions for saving and recalling volume light info
----------------------------------------------------------------------------------------
	fn GetVolumeInfo CurLight=
	(
		local VolList=#()
		if numAtmospherics != 0 do for j = 1 to numAtmospherics do
			(
			TempAtmos = GetAtmospheric j
			for q = 1 to TempAtmos.numgizmos  do 
				(
				PGizLight = getgizmo TempAtmos q
				if PGizLight == curlight do append VolList j
				)
			
			)
		vollist
	)
	
	fn SetVolumeInfo VolList CurLight =
	(
		for i = 1 to VolList.count do
			(
			TempAtmos = GetAtmospheric VolList[i]
			AppendGizmo TempAtmos CurLight
			)
	)
----------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------
	

on isEnabled return (Filters.Is_Light selection[1]) and (classof selection[1] != miAreaLight)

On Execute Do
(
		local isInvalidLightsInSelection = true
		local sel_Objs = Selection as array
		
		if Sel_Objs.count < 1 then messagebox ~MSGBOX_PLEASE_SEL_SOME_LIGHTS_TO_CONVERT~ title:~CONVERTTOAREALIGHT_TITLE~ --LOC_Notes: localize this
		
		sel_converted = #()

		for i in 1 to Sel_Objs.count do
		(
----------------------------------------------------------------------------------------		
-- This remembers which volume light if any are on the current light.
----------------------------------------------------------------------------------------
		VLNum = GetVolumeInfo Sel_Objs[i]	
		--print vlnum
----------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------
			if (SuperClassof Sel_Objs[i]) == light then
				(
					--checks if the light contained in the selection set is valid or not
					case of
					(
						------------------------------------------------------------------------------------------
						--Omnilights
						(classof Sel_Objs[i] == Omnilight):
							(
								ALight = miarealightomni ()
								Alight.transform = Sel_Objs[i].transform
								ALight.omnilight.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.omnilight.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.omnilight.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.omnilight.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.omnilight.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.omnilight j (getproperty Sel_Objs[i] j) catch ()
								append sel_converted Sel_Objs[i]
								
							)--end case omnilight
							
						------------------------------------------------------------------------------------------
						--Spotlights
						(classof Sel_Objs[i] == freespot or classof Sel_Objs[i] == targetspot):
							(
								ALight = miarealight ()
								Alight.transform = Sel_Objs[i].transform
									if classof Sel_Objs[i] == targetspot do
										(
										tg = targetobject name:(Alight.name + ".target") --LOC_Notes: do not localize this
										tg.transform = Sel_Objs[i].target.transform
										Alight.target = tg
										)
								ALight.targetspot.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.targetspot.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.targetspot.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.targetspot.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.targetspot.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.targetspot j (getproperty Sel_Objs[i] j) catch ()
								append sel_converted Sel_Objs[i]
							)--end if spotlight
							
						------------------------------------------------------------------------------------------
						--Directlights
						(classof Sel_Objs[i] == Directionallight or classof Sel_Objs[i] == TargetDirectionallight):
							(
								ALight = miarealight ()
								Alight.transform = Sel_Objs[i].transform
								if classof Sel_Objs[i] == TargetDirectionallight do
									(
									tg = targetobject name:(Alight.name + ".target") --LOC_Notes: do not localize this
									tg.transform = Sel_Objs[i].target.transform
									Alight.target = tg
									)
								ALight.targetspot.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.targetspot.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.targetspot.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.targetspot.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.targetspot.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.targetspot j (getproperty Sel_Objs[i] j) catch ()
								if Alight.targetspot.coneshape == 1 then
									(
									Alight.Area_Type = 2
									Alight.Disc_Radius = Sel_Objs[i].falloff
									)
								  else
								  	(
									Alight.Area_Type = 1
									Alight.Rectangle_Height = Sel_Objs[i].falloff/Sel_Objs[i].aspect*2
									Alight.Rectangle_Width = Sel_Objs[i].falloff*2
									)
								append sel_converted Sel_Objs[i]
							)--end if directlights
						
						------------------------------------------------------------------------------------------
						--Default
						default: messagebox (~MSGBOX_SELECTED_LIGHT_CANNOT_BE_CONVERTED_TO_MR_AREA_LIGHT~ + (Sel_Objs[i].name) + ~IT_WILL_BE_SKIPPED_BY_THE_UTILITY~) title:~CONVERT_SEL_LIGHTS_TITLE~ --LOC_Notes: localize this
					)--end case

				)--end if selected object classof light

			if VLnum != OK do SetVolumeInfo VLnum Alight				
		)
		if sel_converted.count > 0 do
		(
			if querybox ~QUERYBOX_DELETE_OLD_LIGHTS_CAPTION~ then --LOC_Notes: localize this
			(

					for i in 1 to sel_converted.count do
						(
		
						undo on (Delete sel_converted[i])
				
						)


			)--end then
			else
			(

					for i in 1 to sel_converted.count do
						(
		
						undo on ( Try(sel_converted[i].on = false)Catch ())
				
						)


			)--end else
		)--end if sel_converted.count > 0 do
	
	)--end on execute

)--end macro


-------------------------------------------------------------------------------------------------------
/*
mental ray Proxy utility macroscript

*/

macroScript mrProxyBake
 category:"mental ray"
 internalcategory:"mental ray"
 ButtonText:~MRPROXYBAKE_BUTTONTEXT~
 Tooltip:~MRPROXYBAKE_TOOLTIP~ 
(--	macro begins
	
	on isVisible return ((classof renderers.current == mental_ray_renderer) and 
		((Selection.count == 1) and
			((superClassof Selection[1] == GeometryClass) and (CanConvertTo Selection[1] Mesh))))
	on isEnabled return ((classof renderers.current == mental_ray_renderer) and 
		((Selection.count == 1) and
			((superClassof Selection[1] == GeometryClass) and (CanConvertTo Selection[1] Mesh))))
	
	on execute do with undo ~EXECUTE_UNDO_CONVERT_TO_MR_PROXY~ on	
	(
		-- Create a proxy object
		proxy = mr_Proxy()
		
		if ((proxy.writeProxyDlg Selection[1] replace:false) == false) then
		(
			delete proxy -- Get rid of it again, the bake failed!
		)
	)
) -- macro ends

-------------------------------------------------------------------------------------------------------
/*
mental ray Proxy object creation

*/

macroScript mrProxy
			category:"mental ray" 
			internalCategory:"mental ray" 
			tooltip:~MRPROXY_TOOLTIP~
			buttontext:~MRPROXY_BUTTONTEXT~ 
(
	on execute do StartObjectCreation mr_Proxy
	on isChecked return (mcrUtils.IsCreating mr_Proxy)
)

